# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 9
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3): Cooperate unless opponent defects early (Grim Trigger)
    if current_round <= 3:
        if "D" in opp_history[:current_round-1]:
            return "D"
        return "C"
    
    # Middle Rounds (4-7): Forgiving Tit-for-Tat
    elif current_round <= 7:
        if opp_history[-1] == "D":
            return "D"
        else:
            return "C"
    
    # Late Rounds (8-10)
    else:
        if current_round == 8:
            return "D"
        elif current_round == 9:
            if opp_history[-1] == "C":
                return "C"
            else:
                return "D"
        elif current_round == 10:
            return "D"
    
    # Default fallback (shouldn't reach here)
    return "D"